***********************************************************s****
* Read in data
***************************************************************

set more off
clear
* Put name of your main directory path here:
local main = "___"
cd "`main'\Figure 12"
import excel "Figure 12 - Decomposition Input.xlsx", sheet("chart data") cellrange(A2:E8) firstrow clear

***************************************************************
* Set color scheme (optional)
***************************************************************

set scheme s1color

***************************************************************
* Data work
***************************************************************

* Format variables
format PT H Value %9.2f

replace Item = "V/U" if Item =="Slack"
replace Item = "Backlogs of work" if Item =="Backlog"
replace Item = "Energy prices" if Item =="Energy"
replace Item = "Auto prices" if Item =="Auto"

***************************************************************
* Chart
***************************************************************

local title = ""
local index = 0
local label1 = "Passthrough"
local label2 = "Headline inflation shock"

graph bar PT H Value, over(Item, sort(Order)) stack ///
bar(1, color(blue)) bar(2, color(red)) bar(3, color(gs11)) ///
ysize(2.8) ///
ylabel(-0.5(.5)3.0) ///
blabel(bar, pos(top) format(%9.2f)) ///
legend(label(1 `label1') label(2 `label2') order(2 1) row(3) symxsize(4) ring(0) position(1) bmargin(none) region(style(none))) xsize(5)

cd `main'